% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGenome.R
\name{getGenome}
\alias{getGenome}
\title{Retrieve a genome from the OMA Browser database}
\usage{
getGenome(id = NULL, attribute = NULL)
}
\arguments{
\item{id}{A genome identifier. By default, all available genomes will be returned.}

\item{attribute}{An extra attribute to be returned (proteins)}
}
\value{
an object containing the JSON keys as attributes or a dataframe
}
\description{
This function obtains the basic information for one specific genome available
on the OMA Browser, or - if no id is provided - a dataframe with all available
genomes.
}
\details{
Ids can be either the scientific name of a species, the NCBI taxonomy id or
the UniProtKB mnemonic species code.

The optional argument attribute can be used to directly load the proteins
belonging to the genome. Alternatively, you can access the proteins attribute
of the result which will transparently load the proteins from the OMA Browser.
}
\examples{
getGenome()
getGenome(id='HUMAN')
getGenome(id=9606)
getGenome(id='HUMAN',attribute='proteins')
}
