% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot.R
\name{all_uniprot_acs}
\alias{all_uniprot_acs}
\title{All UniProt ACs for one organism}
\usage{
all_uniprot_acs(organism = 9606, reviewed = TRUE)
}
\arguments{
\item{organism}{Character or integer: name or identifier of the organism.}

\item{reviewed}{Retrieve only reviewed (`TRUE`), only unreviewed (`FALSE`)
or both (`NULL`).}
}
\value{
Character vector of UniProt accession numbers.
}
\description{
All UniProt ACs for one organism
}
\examples{
human_swissprot_acs <- all_uniprot_acs()
human_swissprot_acs[1:5]
# [1] "P51451" "A6H8Y1" "O60885" "Q9Y3X0" "P22223"
length(human_swissprot_acs)
# [1] 20376
mouse_swissprot_acs <- all_uniprot_acs("mouse")

}
