% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kegg.R
\name{kegg_pathway_annotations}
\alias{kegg_pathway_annotations}
\title{Protein pathway annotations}
\usage{
kegg_pathway_annotations(pathways = NULL)
}
\arguments{
\item{pathways}{A table of KEGG pathways as produced by \code{
\link{kegg_pathways_download}}.}
}
\value{
A data frame (tibble) with UniProt IDs and pathway names.
}
\description{
Downloads all KEGG pathways and creates a table of protein-pathway
annotations.
}
\examples{
\dontrun{
kegg_pw_annot <- kegg_pathway_annotations()
kegg_pw_annot
# # A tibble: 7,341 x 4
#    uniprot genesymbol pathway                pathway_id
#    <chr>   <chr>      <chr>                  <chr>
#  1 Q03113  GNA12      MAPK signaling pathway hsa04010
#  2 Q9Y4G8  RAPGEF2    MAPK signaling pathway hsa04010
#  3 Q13972  RASGRF1    MAPK signaling pathway hsa04010
#  4 O95267  RASGRP1    MAPK signaling pathway hsa04010
#  5 P62834  RAP1A      MAPK signaling pathway hsa04010
# # . with 7,336 more rows
}

}
\seealso{
\code{\link{kegg_pathways_download}}
}
