% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{omnipath_cache_set_ext}
\alias{omnipath_cache_set_ext}
\title{Sets the file extension for a cache record}
\usage{
omnipath_cache_set_ext(key, ext)
}
\arguments{
\item{key}{Character: key for a cache item, alternatively a version entry.}

\item{ext}{Character: the file extension, e.g. "zip".}
}
\value{
Returns `NULL`.
}
\description{
Sets the file extension for a cache record
}
\examples{
bioc_url <- 'https://bioconductor.org/'
version <- omnipath_cache_latest_or_new(url = bioc_url)
version$path
# [1] "/home/denes/.cache/OmnipathR/41346a00fb20d2a9df03-1"
curl::curl_fetch_disk(bioc_url, version$path)
key <- omnipath_cache_key(url = bioc_url)
omnipath_cache_set_ext(key = key, ext = 'html')
version <- omnipath_cache_latest_or_new(url = bioc_url)
version$path
# [1] "/home/denes/.cache/OmnipathR/41346a00fb20d2a9df03-1.html"
record <- omnipath_cache_get(url = bioc_url)
record$ext
# [1] "html"
omnipath_cache_remove(url = bioc_url) # cleaning up

}
