% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{organism_for}
\alias{organism_for}
\title{Make sure the resource supports the organism and it has the ID}
\usage{
organism_for(organism, resource, error = TRUE)
}
\arguments{
\item{organism}{Character or integer: name or NCBI Taxonomy ID of the
organism.}

\item{resource}{Charater: name of the resource.}

\item{error}{Logical: raise an error if the organism is not supported in the
resource. Otherwise it only emits a warning.}
}
\value{
Character: the ID of the organism as it is used by the resource. NA
    if the organism can not be translated to the required identifier type.
}
\description{
Make sure the resource supports the organism and it has the ID
}
\examples{
organism_for(10116, 'chalmers-gem')
# [1] "Rat"
organism_for(6239, 'chalmers-gem')
# [1] "Worm"
# organism_for('foobar', 'chalmers-gem')
# Error in organism_for("foobar", "chalmers-gem") :
# Organism `foobar` (common_name: `NA`; common_name: `NA`)
# is not supported by resource `chalmers-gem`. Supported organisms:
# Human, Mouse, Rat, Zebrafish, Drosophila melanogaster (Fruit fly),
# Caenorhabditis elegans (PRJNA13758).

}
