% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{pivot_annotations}
\alias{pivot_annotations}
\title{Converts annotation tables to a wide format}
\usage{
pivot_annotations(annotations)
}
\arguments{
\item{annotations}{A data frame of annotations downloaded from the
OmniPath web service by \code{\link{annotations}}.}
}
\value{
A wide format data frame (tibble) if the provided data contains
annotations from one resource, otherwise a list of wide format tibbles.
}
\description{
Use this method to reconstitute the annotation tables into the format of
the original resources. With the `wide=TRUE` option
\code{\link{annotations}} applies this function to the
downloaded data.
}
\examples{
# single resource: the result is a data frame
disgenet <- annotations(resources = "DisGeNet")
disgenet <- pivot_annotations(disgenet)
disgenet
# # A tibble: 126,588 × 11
#    uniprot genesymbol entity_type disease      type  score   dsi   dpi
#    <chr>   <chr>      <chr>       <chr>        <chr> <dbl> <dbl> <dbl>
#  1 P04217  A1BG       protein     Schizophren. dise.  0.3  0.7   0.538
#  2 P04217  A1BG       protein     Hepatomegaly phen.  0.3  0.7   0.538
#  3 P01023  A2M        protein     Fibrosis, L. dise.  0.3  0.529 0.769
#  4 P01023  A2M        protein     Acute kidne. dise.  0.3  0.529 0.769
#  5 P01023  A2M        protein     Mental Depr. dise.  0.3  0.529 0.769
# # . with 126,583 more rows, and 3 more variables: nof_pmids <dbl>,
# #   nof_snps <dbl>, source <chr>

# multiple resources: the result is a list
annot_long <- annotations(
    resources = c("DisGeNet", "SignaLink_function", "DGIdb", "kinase.com")
)
annot_wide <- pivot_annotations(annot_long)
names(annot_wide)
# [1] "DGIdb"              "DisGeNet"           "kinase.com"
# [4] "SignaLink_function"
annot_wide$kinase.com
# # A tibble: 825 x 6
#    uniprot genesymbol entity_type group family subfamily
#    <chr>   <chr>      <chr>       <chr> <chr>  <chr>
#  1 P31749  AKT1       protein     AGC   Akt    NA
#  2 P31751  AKT2       protein     AGC   Akt    NA
#  3 Q9Y243  AKT3       protein     AGC   Akt    NA
#  4 O14578  CIT        protein     AGC   DMPK   CRIK
#  5 Q09013  DMPK       protein     AGC   DMPK   GEK
# # . with 815 more rows

}
\seealso{
\code{\link{annotations}}
}
