% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stitch.R
\name{stitch_remove_prefixes}
\alias{stitch_remove_prefixes}
\title{Remove the prefixes from STITCH identifiers}
\usage{
stitch_remove_prefixes(d, ..., remove = TRUE)
}
\arguments{
\item{d}{Data frame, typically the output of \code{\link{stitch_links}} or
\code{\link{stitch_actions}}.}

\item{...}{Names of columns to remove prefixes from. NSE is supported.}

\item{remove}{Logical: remove the prefixes? If FALSE, this function does
nothing.}
}
\value{
Data frame with prefixes removed in the specified columns.
}
\description{
STITCH adds the NCBI Taxonomy ID as a prefix to Ensembl protein identifiers,
e.g. "9606.ENSP00000170630", and "CID" followed by "s" or "m"
(stereospecific or merged, respectively) in front of PubChem Compound
Identifiers. It also pads the CID with zeros. This function removes these
prefixes, leaving only the identifiers.
}
\examples{
stitch_remove_prefixes(
    data.frame(a = c('9606.ENSP00000170630', 'CIDs00012345')),
    a
)

}
\seealso{
\itemize{
    \item{\code{\link{stitch_actions}}}
    \item{\code{\link{stitch_links}}}
    \item{\code{\link{stitch_network}}}
}
}
