% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenodo.R
\name{zenodo_download}
\alias{zenodo_download}
\title{Retrieves data from Zenodo}
\usage{
zenodo_download(
  path,
  reader = NULL,
  reader_param = list(),
  url_key = NULL,
  zenodo_record = NULL,
  zenodo_fname = NULL,
  url_param = list(),
  url_key_param = list(),
  ...
)
}
\arguments{
\item{path}{Character: path to the file within the archive.}

\item{reader}{Optional, a function to read the connection.}

\item{reader_param}{List: arguments for the reader function.}

\item{url_key}{Character: name of the option containing the URL}

\item{zenodo_record}{The Zenodo record ID, either integer or character.}

\item{zenodo_fname}{The file name within the record.}

\item{url_param}{List: variables to insert into the URL string (which is
returned from the options).}

\item{url_key_param}{List: variables to insert into the `url_key`.}

\item{...}{Passed to \code{archive_extractor}}
}
\value{
A connection
}
\description{
Zenodo is a repository of large scientific datasets. Many projects and
publications make their datasets available at Zenodo. This function
downloads an archive from Zenodo and extracts the requested file.
}
\examples{
# an example from the OmnipathR::remap_tf_target_download function:
remap_dorothea <- zenodo_download(
    zenodo_record = 3713238,
    zenodo_fname = 'tf_target_sources.zip',
    path = (
        'tf_target_sources/chip_seq/remap/gene_tf_pairs_genesymbol.txt'
    ),
    reader = read_tsv,
    reader_param = list(
        col_names = c(
            'source_genesymbol',
            'target_genesymbol',
            'target_ensembl',
            'score'
        ),
        col_types = cols(),
        progress = FALSE
    ),
  resource = 'ReMap'
)

}
