% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPsa.R
\name{readPsa}
\alias{readPsa}
\title{Parse a PSA (PROSITE Scan ASCII) File}
\usage{
readPsa(psa_file)
}
\arguments{
\item{psa_file}{A character string specifying the path to the input PSA file.}
}
\value{
A data frame with a GFF-like structure, including all original
  placeholder columns.
}
\description{
This function reads a file in PSA format and converts it into a
standardized, GFF-like data frame for downstream analysis. It is robust
to files that may contain extraneous, non-PSA formatted data at the end.
}
\examples{
# Get the path to the example PSA file included with the package
psa_file_path <- system.file("extdata", "out_Hb_psa.txt", package = "PMScanR")

# Check that the file exists before running the example
if (nzchar(psa_file_path)) {
  gff_like_data <- readPsa(psa_file_path)
  # You can view the output with:
  # head(gff_like_data)
}

}
