% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createProfilePlot.R
\name{dataCustomizedPlot}
\alias{dataCustomizedPlot}
\title{Create data for customized profile plot}
\usage{
dataCustomizedPlot(dataHeat = NULL, selectedTaxa = "all",
    selectedSeq = "all")
}
\arguments{
\item{dataHeat}{a data frame contains processed profiles (see
?fullProcessedProfile, ?filterProfileData)}

\item{selectedTaxa}{selected subset of taxa. Default = "all".}

\item{selectedSeq}{selected subset of genes. Default = "all".}
}
\value{
A dataframe contains data for plotting the customized profile.
}
\description{
Create data for customized profile plot based on a selected
list of genes and/or taxa, containing seed protein IDs (geneID), ortholog IDs
(orthoID) together with their ncbi taxonomy IDs (ncbiID and abbrName), full
names (fullName), indexed supertaxa (supertaxon), values for additional
variables (var1, var2) and the aggregated values of those additional
variables for each supertaxon (mVar1, mVar2), number of original and filtered
co-orthologs in each supertaxon (paralog and paralogNew), number of species
in each supertaxon (numberSpec) and the % of species that have orthologs in
each supertaxon (presSpec).
}
\examples{
data("finalProcessedProfile", package="PhyloProfile")
selectedTaxa <- c("Mammalia", "Saccharomycetes", "Insecta")
selectedSeq <- "all"
dataCustomizedPlot(finalProcessedProfile, selectedTaxa, selectedSeq)
}
\seealso{
\code{\link{filterProfileData}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
