% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umapClustering.R
\name{dimReduction}
\alias{dimReduction}
\title{Perform dimension reduction 2D}
\usage{
dimReduction(data4dimRed = NULL, by = "taxa", type = "binary",
    randomSeed = 123, reductionTechnique = "umap", dimension = "2d",
    tsneIter = 1000)
}
\arguments{
\item{data4dimRed}{data for dimension reduction (from prepareDimRedData)}

\item{by}{cluster data by "taxa" (default) or "genes"}

\item{type}{type of data, either "binary" (default) or "non-binary"}

\item{randomSeed}{random seed. Default: 123}

\item{reductionTechnique}{dimensionality reduction technique, either "umap"
(default) or "tsne"}

\item{dimension}{either "2d" (default) or "3d"}

\item{tsneIter}{number of iterations for t-SNE. Default: 1000}
}
\value{
A table contains coordinates of the 2D dimension reduction
}
\description{
Perform dimension reduction 2D
}
\examples{
rawInput <- system.file(
   "extdata", "test.main.long", package = "PhyloProfile", mustWork = TRUE
)
longDf <- createLongMatrix(rawInput)
data4dimRed <- prepareDimRedData(longDf, "phylum")
dimReduction(data4dimRed)
}
\seealso{
\code{\link{prepareDimRedData}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
