% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTaxonomyMatrix.R
\name{getIDsRank}
\alias{getIDsRank}
\title{Get taxonomy info for a list of taxa}
\usage{
getIDsRank(inputTaxa = NULL, currentNCBIinfo = NULL)
}
\arguments{
\item{inputTaxa}{NCBI ID list of input taxa.}

\item{currentNCBIinfo}{table/dataframe of the pre-processed NCBI taxonomy
data (/PhyloProfile/data/preProcessedTaxonomy.txt)}
}
\value{
A list of 3 dataframes: idList, rankList and reducedInfoList. The
"rankList" contains taxon names and all taxonomy ranks of the input taxa
including also the noranks from the input rank to the taxonomy root. The
"idList" contains input taxon IDs, taxon names, all the ranks from current
rank to the taxonomy root together with their IDs (with the format
"id#rank"). The reducedInfoList is a subset of preProcessedTaxonomy.txt file,
containing the NCBI IDs, taxon fullnames, their current rank and their
direct parent ID.
}
\description{
Get NCBI taxonomy IDs, ranks and names for an input taxon list.
}
\examples{
inputTaxa <- c("272557", "176299")
ncbiFilein <- system.file(
    "extdata", "data/preProcessedTaxonomy.txt",
    package = "PhyloProfile", mustWork = TRUE
)
currentNCBIinfo <- as.data.frame(data.table::fread(ncbiFilein))
getIDsRank(inputTaxa, currentNCBIinfo)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
