% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SE.R
\name{pirat2SE}
\alias{pirat2SE}
\title{COnvert Pirat dataset to SummarizedExperiment}
\usage{
pirat2SE(peptides_ab, adj, mask_prot_diff = NULL, mask_pep_diff = NULL)
}
\arguments{
\item{peptides_ab}{the peptide or precursor abundance matrix to impute, 
with samples in row and peptides or precursors in column;}

\item{adj}{a n_peptide x n_protein adjacency matrix between peptides and 
proteins containing 0 and 1, or TRUE and FALSE.
Can contain: 
**rnas_ab**, the mRNA normalized count matrix, with samples in 
row and mRNAs in column;
**adj_rna_pg**, a n_mrna x n_protein adjacency matrix n_mrna and proteins 
containing 0 and 1, or TRUE and FALSE;}

\item{mask_prot_diff}{(Optional) boolean vector of size equal to the number of proteins, indicating
whether proteins are ground truth differentially abundant (typically in spike-in benchmark datasets).}

\item{mask_pep_diff}{(Optional) boolean vector of size equal to the number of peptides, indicating
whether peptides are ground truth differentially abundant (typically in spike-in benchmark datasets).}
}
\value{
An instance of the class `SummarizedExperiment`
}
\description{
This function converts the original dataset structure into 
a SummarizedExperiment .
}
\examples{
data(subbouyssie)
peptides_ab <- subbouyssie$peptides_ab
adj <- subbouyssie$adj
mask_prot_diff <- subbouyssie$mask_prot_diff
mask_pep_diff <- subbouyssie$mask_pep_diff
obj <- pirat2SE(peptides_ab, adj, mask_prot_diff, mask_pep_diff )
obj

}
