% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filters.R
\name{createColumnFilter}
\alias{createColumnFilter}
\title{Create Column Filter}
\usage{
createColumnFilter(
  filter.name,
  column,
  criterion,
  predicate,
  caseSensitive = FALSE,
  anyMatch = TRUE,
  type = "nodes",
  hide = FALSE,
  network = NULL,
  base.url = .defaultBaseUrl,
  apply = TRUE
)
}
\arguments{
\item{filter.name}{Name for filter.}

\item{column}{Table column to base filter upon.}

\item{criterion}{For boolean columns: TRUE or FALSE. For string columns: a 
string value, e.g., "hello". If the predicate is REGEX then this can be a 
regular expression as accepted by the Java Pattern class 
(https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html). For 
numeric columns: If the predicate is BETWEEN or IS_NOT_BETWEEN then this is 
a two-element vector of numbers, example: c(1,5), otherwise a single number.}

\item{predicate}{For boolean columns: IS, IS_NOT. For string columns: IS, 
IS_NOT, CONTAINS, DOES_NOT_CONTAIN, REGEX. For numeric columns: IS, IS_NOT, 
GREATER_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN, LESS_THAN_OR_EQUAL, BETWEEN, 
IS_NOT_BETWEEN}

\item{caseSensitive}{(optional) If string matching should be case sensitive. 
Default is FALSE.}

\item{anyMatch}{(optional) Only applies to List columns. If true then at least 
one element in the list must pass the filter, if false then all the elements 
in the list must pass the filter. Default is TRUE.}

\item{type}{(optional) Apply filter to "nodes" (default) or "edges".}

\item{hide}{Whether to hide filtered out nodes and edges. Default is FALSE.
Ignored if all nodes or edges are filtered out. This is an alternative to 
filtering for node and edge selection.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}

\item{apply}{(bool) True to execute filter immediately (default); False to
define filter but not execute it (available in Cytoscape 3.9+).}
}
\value{
List of selected nodes and edges.
}
\description{
Creates a filter to control node or edge selection. Works on
columns of boolean, string, numeric and lists. Note the unique restrictions
for criterion and predicate depending on the type of column being filtered.
}
\examples{
\donttest{
createColumnFilter('myFilter', 'log2FC', c(-1,1), "IS_NOT_BETWEEN")
createColumnFilter('myFilter', 'pValue', 0.05, "LESS_THAN")
createColumnFilter('myFilter', 'function', "kinase", "CONTAINS", FALSE)
createColumnFilter('myFilter', 'name', "^Y.*C$", "REGEX")
createColumnFilter('myFilter', 'isTarget', TRUE , "IS", apply=FALSE)
createColumnFilter('myFilter', 'isTarget', TRUE , "IS", hide=TRUE)
}
}
