% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layouts.R
\name{getLayoutNames}
\alias{getLayoutNames}
\title{Get Layout Names}
\usage{
getLayoutNames(base.url = .defaultBaseUrl)
}
\arguments{
\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
A \code{list} of \code{character} strings, e.g., "force-directed" "circular" "grid"
}
\description{
Retrieve the names of the currently supported layout algorithms.  These
may be used in subsequent calls to the 'layoutNetwork' function.
}
\examples{
\donttest{
getLayoutNames()
# [1] "degree-circle"         "attributes-layout"      "kamada-kawai"                    
# [4] "force-directed"        "cose"                   "hierarchical"                    
# [7] "attribute-circle"      "stacked-node-layout"    "circular"
}
}
\author{
Alexander Pico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
