% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{groupAnnotation}
\alias{groupAnnotation}
\title{Group Annotation}
\usage{
groupAnnotation(names = NULL, network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{names}{Name of annotation by UUID or Name}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is 
http://localhost:1234 and the latest version of the CyREST API supported by 
this version of RCy3.}
}
\value{
UUID of group annotation
}
\description{
Group annotation from the network view in Cytoscape
}
\details{
You can obtain a list of UUIDs by applying a subset function
like so: sapply(getAnnotationList(), '[[', 'uuid')
}
\examples{
\donttest{
groupAnnotation(c("29ac8349-7be4-404e-8363-9537cc39d1ad","3846e949-3130-4362-83de-d02f5368e3ad"))
groupAnnotation(c("annotation1","annotation2", "annotation3"))
groupAnnotation("annotation1")
groupAnnotation(sapply(getAnnotationList(), '[[', 'uuid'))
}
}
