% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_data.R
\name{create_empty_zarr_array}
\alias{create_empty_zarr_array}
\title{Create an (empty) Zarr array}
\usage{
create_empty_zarr_array(
  zarr_array_path,
  dim,
  chunk_dim,
  data_type,
  order = "F",
  compressor = use_zlib(),
  fill_value,
  nchar = NULL,
  dimension_separator = "."
)
}
\arguments{
\item{zarr_array_path}{Character vector of length 1 giving the path to the
new Zarr array.}

\item{dim}{Dimensions of the new array.  Should be a numeric vector with the
same length as the number of dimensions.}

\item{chunk_dim}{Dimensions of the array chunks. Should be a numeric vector
with the same length as the \code{dim} argument.}

\item{data_type}{Character vector giving the data type of the new array.
Currently this is limited to standard R data types.  Valid options are:
"integer", "double", "character".  You can also use the analogous NumpPy
formats: "<i4", "<f8", "|S".  If this argument isn't provided the
\code{fill_value} will be used to determine the datatype.}

\item{order}{Define the layout of the bytes within each chunk.  Valid options
are 'column', 'row', 'F' & 'C'.  'column' or 'F' will specify
"column-major" ordering, which is how R arrays are arranged in memory.
'row' or 'C' will specify "row-major" order.}

\item{compressor}{What (if any) compression tool should be applied to the
array chunks.  The default is to use \code{zlib} compression. Supplying \code{NULL}
will disable chunk compression. See \link{compressors} for more details.}

\item{fill_value}{The default value for uninitialized portions of the array.
Does not have to be provided, in which case the default for the specified
data type will be used.}

\item{nchar}{For \code{datatype = "character"} this parameter gives the maximum
length of the stored strings. It is an error not to specify this for a
character array, but it is ignored for other data types.}

\item{dimension_separator}{The character used to to separate the dimensions
in the names of the chunk files.  Valid options are limited to "." and "/".}
}
\value{
If successful returns (invisibly) \code{TRUE}.  However this function is
primarily called for the size effect of initialising a Zarr array location
and creating the \code{.zarray} metadata.
}
\description{
Create an (empty) Zarr array
}
\examples{

new_zarr_array <- file.path(tempdir(), "temp.zarr")
create_empty_zarr_array(new_zarr_array,
  dim = c(10, 20), chunk_dim = c(2, 5),
  data_type = "integer"
)

}
\seealso{
\code{\link[=write_zarr_array]{write_zarr_array()}}, \code{\link[=update_zarr_array]{update_zarr_array()}}
}
