% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-transcription-rates-class.R
\name{estimateTranscriptionRates}
\alias{estimateTranscriptionRates}
\title{Generic function for estimating transcription rates}
\usage{
estimateTranscriptionRates(x, ...)
}
\arguments{
\item{x}{The input data (either a SimulatePolymerase object or bigwig files)}

\item{...}{Additional arguments passed to the specific methods}
}
\value{
An object containing estimated transcription rates
}
\description{
Generic function that estimates transcription rates from either simulation
data (SimulatePolymerase object) or experimental data (bigwig files and
genomic regions).
}
\examples{
load(system.file("extdata", "granges_for_read_counting_DLD1_chr21.RData",
package = "STADyUM"))
expRates <- estimateTranscriptionRates(system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_plus_chr21.bw", package = "STADyUM"),
bigwigMinus = system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_minus_chr21.bw", package = "STADyUM"),
    pauseRegions = bw_pause_filtered,
    geneBodyRegions = bw_gb_filtered,
    name = "Control",
    stericHindrance = TRUE,
    omegaScale = 1000
)
}
