% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotUtils.R
\name{createPaletteFromColData}
\alias{createPaletteFromColData}
\title{createPaletteFromColData}
\usage{
createPaletteFromColData(spe, paletteNames, paletteColors)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with spatial transcriptomics data.}

\item{paletteNames}{A character string specifying the column in
`colData(spe)` to be used for the names in the palette.}

\item{paletteColors}{A character string specifying the column in
`colData(spe)` to be used for the colors in the palette.}
}
\value{
A character vector representing the palette mapping, where each
element is a string in the format `"name=color"`.
}
\description{
Create a Palette from colData in a SpatialExperiment Object

This function generates a palette mapping based on specified columns in
the `colData` of a `SpatialExperiment` object.
}
\details{
The function creates a new palette based on the unique combinations
of values in the specified `paletteNames` and `paletteColors` columns in
`colData(spe)`.
}
\keyword{internal}
