% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{readPolygons}
\alias{readPolygons}
\title{readPolygons}
\usage{
readPolygons(
  polygonsFile,
  type = c("csv", "parquet", "h5"),
  x = c("x_global_px", "vertex_x"),
  y = c("y_global_px", "vertex_y"),
  xloc = "x_local_px",
  yloc = "y_local_px",
  keepMultiPol = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{polygonsFile}{A character string specifying the path to the polygon
file.}

\item{type}{A character string specifying the file type. Supported types are
`"csv"`, `"parquet"`, and `"h5"`. Default is `"csv"`.}

\item{x}{A character vector specifying the column names for the x-coordinates
in the polygon data. Default is `c("x_global_px", "vertex_x")`.}

\item{y}{A character vector specifying the column names for the y-coordinates
in the polygon data. Default is `c("y_global_px", "vertex_y")`.}

\item{xloc}{A character string specifying the column name for the local
x-coordinates. Default is `"x_local_px"`.}

\item{yloc}{A character string specifying the column name for the local
y-coordinates. Default is `"y_local_px"`.}

\item{keepMultiPol}{A logical value indicating whether to keep multipolygons
during validation. Default is `TRUE`.}

\item{verbose}{A logical value indicating whether to print additional
information during processing. Default is `FALSE`.}
}
\value{
An `sf` object with the loaded and validated polygons.
}
\description{
Read and Validate Polygons from a File

This function reads polygon data from a specified file, validates the
polygons, and returns them as an `sf` object. It supports multiple file
formats and can handle both global and local coordinates.
}
\details{
The function reads polygon data from the specified file and formats.
It validates the polygons and handles both global and local coordinates if
provided. If the file type is `"h5"`, the function currently does not handle
the data, as this part of the code is not implemented.
}
\examples{
example(readCosmxSPE)
polygons <- readPolygons(metadata(spe)$polygons)
polygons
}
