% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-functions.R
\name{fragmentGroupIndex}
\alias{fragmentGroupIndex}
\title{Mass fragmentation collections of each full scan}
\usage{
fragmentGroupIndex(object, BPPARAM = SerialParam())
}
\arguments{
\item{object}{A \code{Spectra} object (from the \strong{Spectra} package) containing
MS data. Must include at least two MS levels (\code{msLevel}) and
be ordered by \code{acquisitionNum} within each \code{dataOrigin}.}

\item{BPPARAM}{A \code{BiocParallelParam} object for parallel execution.
Defaults to \code{SerialParam()}.}
}
\value{
An \code{integer} vector of the same length as \code{object}.
Each element gives the group index associated with the corresponding
spectrum (MS1 or MS^n). Group indices are unique across all files
(\code{dataOrigin} values).
}
\description{
This function generates an \code{integer} index grouping MS^n spectra
(MS level > 1) with their corresponding MS1 spectra based on acquisition
order. Each group contains exactly one MS1 spectrum and all subsequent
higher-level spectra (MS2, MS3, ...) acquired until the next MS1 scan.
MS1-only spectra are also assigned sequential group IDs.

Note that this function:
\itemize{
\item does not consider the direct relationship between a precursor scan and
the associated product scans,
\item and does not distinguish between different fragmentation trees.
}

For example, all MS3 scans measured after a given MS1 are grouped together
with all MS2 scans from that MS1, regardless of which MS2 spectrum they
originated from. See \code{\link[=filterPrecursorScan]{filterPrecursorScan()}} for a function that considers
relationships between fragment and precursor scans.
}
\note{
\itemize{
\item Each file (\code{dataOrigin}) must contain at least one MS1 spectrum.
\item If a group contains only MS1 spectra, each MS1 is assigned a unique group
ID.
\item The user is responsible for ensuring that spectra are correctly ordered.
Improper ordering may lead to incorrect groupings.
}
}
\examples{

fl_ms3 <- system.file("proteomics", "MS3TMT11.mzML", package = "msdata")
sps_dda <- Spectra(fl_ms3)
idx <- fragmentGroupIndex(sps_dda)
head(idx)
}
\seealso{
\code{\link[=filterPrecursorScan]{filterPrecursorScan()}} for a function that instead returns a
\code{Spectra} object containing each parent (e.g., MS1) and its direct child
scans (e.g., MS2) according to their acquisition numbers.
}
\author{
Philippine Louail
}
