% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGRangesListFromCopyNumber.R
\name{makeGRangesListFromCopyNumber}
\alias{makeGRangesListFromCopyNumber}
\title{Make a GRangesList from TCGA Copy Number data}
\usage{
makeGRangesListFromCopyNumber(
  df,
  split.field,
  names.field = "Hugo_Symbol",
  ...
)
}
\arguments{
\item{df}{A \code{data.frame} or \code{DataFrame} class object. \code{list}
class objects are coerced to \code{data.frame} or \code{DataFrame}.}

\item{split.field}{A \code{character} vector of length one indicating
the column to be used as sample identifiers}

\item{names.field}{A \code{character} vector of length one indicating the
column to be used as names for each of the ranges in the data}

\item{...}{Additional arguments to pass on to
\link[GenomicRanges:makeGRangesListFromDataFrame]{GenomicRanges::makeGRangesListFromDataFrame}}
}
\value{
A \link[GenomicRanges:GRangesList-class]{GRangesList} class object
}
\description{
\code{makeGRangesListFromCopyNumber} allows the user to convert objects of
class \code{data.frame} or \link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame} to a
\link[GenomicRanges:GRangesList-class]{GRangesList}. It includes additional
features specific to TCGA data such as, hugo symbols, probe numbers, segment
means, and ucsc build (if available).
}
\examples{
library(GenomicDataCommons)

manif <- files() |>
    filter(~ cases.project.project_id == "TCGA-COAD" &
        data_type == "Copy Number Segment") |>
    manifest(size = 1)

fname <- gdcdata(manif$id)

barcode <- UUIDtoBarcode(names(fname), from_type = "file_id")
barcode <- barcode[["associated_entities.entity_submitter_id"]]

cndata <- read.delim(fname[[1L]], nrows = 10L)

cngrl <- makeGRangesListFromCopyNumber(cndata, split.field = "GDC_Aliquot",
    keep.extra.columns = TRUE)

names(cngrl) <- barcode
GenomeInfoDb::genome(cngrl) <- extractBuild(fname[[1L]])
cngrl

}
