% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGRangesListFromExonFiles.R
\name{makeGRangesListFromExonFiles}
\alias{makeGRangesListFromExonFiles}
\title{Read exon-level expression files and create a \code{GRangesList}}
\usage{
makeGRangesListFromExonFiles(
  filepaths,
  sampleNames = NULL,
  fileNames = basename(filepaths),
  getBarcodes = TRUE,
  rangesColumn = "exon",
  nrows = Inf
)
}
\arguments{
\item{filepaths}{character() vector of file paths containing TCGA exon
data usually obtained from the GDC}

\item{sampleNames}{character() vector of TCGA barcodes to be used as
names for the \code{GRangesList} output (default NULL)}

\item{fileNames}{character() vector of file names as downloaded from
the Genomic Data Commons Legacy archive (default \code{basename(filepaths)})}

\item{getBarcodes}{logical(1). Whether to query the GDC API with the
\code{filenameToBarcode} and obtain the TCGA barcodes from the file names
(default TRUE); see details.}

\item{rangesColumn}{character(1). The name of the column in the data
containing the ranges information (default "exon"); see details.}

\item{nrows}{numeric(1). The number of rows to return from each of the files
read in (all rows by default; default Inf)}
}
\value{
A \link[GenomicRanges:GRangesList-class]{GRangesList} object
}
\description{
This function serves to read exon-level expression data. It works for exon
quantification (raw counts and RPKM) and junction quantification
(raw counts) file paths and represents such data as a
\link[GenomicRanges:GRangesList-class]{GRangesList}. The data files can be
downloaded via the Genomic Data Commons (GDC) Legacy Archive.
}
\details{
The \code{rangesColumn} name in the GDC data files is usually "exon"
but can be changed with the \code{rangesColumn} argument, if different.
To avoid programmatically obtaining TCGA barcodes from the GDC
API, set the \code{getBarcodes} to \code{FALSE}. When \code{getBarcodes} is set to
\code{FALSE}, the file names are used to name the elements of the \code{GRangesList}
output.
}
\examples{

## Load example file found in package
pkgDir <- system.file("extdata", package = "TCGAutils", mustWork = TRUE)
exonFile <- list.files(pkgDir, pattern = "cation\\\\.txt$", full.names = TRUE)

filePrefix <- "unc.edu.32741f9a-9fec-441f-96b4-e504e62c5362.1755371."

## Add actual file name manually (due to Windows OS restriction)
makeGRangesListFromExonFiles(exonFile,
    fileNames = paste0(filePrefix, basename(exonFile)),
    sampleNames = "TCGA-AA-3678-01A-01R-0905-07")

}
\author{
M. Ramos
}
