% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxIO-package.R
\docType{package}
\name{TENxIO}
\alias{TENxIO}
\alias{TENxIO-package}
\title{TENxIO: A Bioconductor package for importing 10X Genomics files}
\description{
The package provides file classes based on \code{BiocIO} for common file
extensions found in the 10X Genomics website.
}
\section{Supported file types}{

Here is a table of supported file and file extensions and their imported
classes:\tabular{lll}{
   \strong{Extension} \tab \strong{Class} \tab \strong{Imported as} \cr
   .h5 \tab TENxH5 \tab SingleCellExperiment w/ TENxMatrix \cr
   .mtx / .mtx.gz \tab TENxMTX \tab SummarizedExperiment w/ dgCMatrix \cr
   .tar.gz \tab TENxFileList \tab SingleCellExperiment w/ dgCMatrix \cr
   peak_annotation.tsv \tab TENxPeaks \tab GRanges \cr
   fragments.tsv.gz \tab TENxFragments \tab RaggedExperiment \cr
   .tsv / .tsv.gz \tab TENxTSV \tab tibble \cr
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/waldronlab/TENxIO}
  \item Report bugs at \url{https://github.com/waldronlab/TENxIO/issues}
}

}
\author{
\strong{Maintainer}: Marcel Ramos \email{marcel.ramos@sph.cuny.edu} (\href{https://orcid.org/0000-0002-3242-0582}{ORCID})

}
