% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxMTX-class.R
\docType{class}
\name{TENxMTX-class}
\alias{TENxMTX-class}
\alias{.TENxMTX}
\alias{import,TENxMTX,ANY,ANY-method}
\title{TENxMTX: The Matrix Market representation class for 10X Data}
\usage{
\S4method{import}{TENxMTX,ANY,ANY}(con, format, text, ...)
}
\arguments{
\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}

\item{...}{Parameters to pass to the format-specific method.}
}
\value{
A \code{TENxMTX} class object
}
\description{
This class is designed to work with 10x MTX datasets,
particularly from the multiome pipelines.
}
\details{
The \code{TENxMTX} class is a straightforward implementation that allows
the user to import a Matrix Market file format using \code{Matrix::readMM}.
Currently, it returns a \code{SummarizedExperiment} with an internal \code{dgCMatrix}
assay. To request other formats, please open an issue on GitHub.
}
\section{Methods (by generic)}{
\itemize{
\item \code{import(con = TENxMTX, format = ANY, text = ANY)}: Import method mainly for mtx.gz files from 10x

}}
\section{Slots}{

\describe{
\item{\code{compressed}}{logical(1) Whether or not the file is in compressed format,
usually gzipped (\code{.gz}).}
}}

