% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{annotate_intermut_dist_PID}
\alias{annotate_intermut_dist_PID}
\title{Annotate the intermutation distance of variants per PID}
\usage{
annotate_intermut_dist_PID(
  in_dat,
  in_CHROM.field = "CHROM",
  in_POS.field = "POS",
  in_mode = "min",
  in_verbose = FALSE
)
}
\arguments{
\item{in_dat}{VRanges object or data frame which carries (at least) one
column for the chromosome and one column for the position.}

\item{in_CHROM.field}{String indicating which column of \code{in_dat} carries
the chromosome information if dealing with data frames.}

\item{in_POS.field}{String indicating which column of \code{in_dat} carries
the position information if dealing with data frames.}

\item{in_mode}{String passed to \code{\link[circlize]{rainfallTransform}}
indicating which method to choose for the computation of the
intermutational distance.}

\item{in_verbose}{Whether verbose or not.}
}
\value{
VRanges object or data frame identical to \code{in_dat}, but with the
  intermutation distance annotated as an additional column on the right named
  \code{dist}.
}
\description{
The function annotates the intermutational distance to a PID wide data frame
by applying \code{\link[circlize]{rainfallTransform}} to every
chromosome-specific subfraction of the PID wide data.
}
\examples{
test_df <- data.frame(
 CHROM=c(1,1,1,2,2,2,3,3,3,4,4,4,5,5),
 POS=c(1,2,4,4,6,9,1,4,8,10,20,40,100,200),
 REF=c("C","C","C","T","T","T","A","A","A","G","G","G","N","A"),
 ALT=c("A","G","T","A","C","G","C","G","T","A","C","T","A","N"))
min_dist_df <- annotate_intermut_dist_PID(test_df,in_CHROM.field="CHROM",
                                          in_POS.field="POS",
                                          in_mode="min")
max_dist_df <- annotate_intermut_dist_PID(test_df,in_CHROM.field="CHROM",
                                          in_POS.field="POS",
                                          in_mode="max")
min_dist_df
max_dist_df

}
\seealso{
\code{\link{annotate_intermut_dist_cohort}}

\code{\link[circlize]{rainfallTransform}}
}
