% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indel_functions.R
\name{confidence_indel_only_calulation}
\alias{confidence_indel_only_calulation}
\title{Wrapper to compute confidence intervals for only INDEL signatures.}
\usage{
confidence_indel_only_calulation(in_current_indel_df)
}
\arguments{
\item{in_current_indel_df}{A INDEL mutational catalog. Mutational catalog can
be constucted with \code{\link{create_indel_mutation_catalogue_from_df}}}
}
\value{
A list is returned containing two object. First, the \code{p} gtable
object which can be used for gaphically visualization, and second a dataframe
containing the corrosponding upper and lower bounds of the confidence
intervals.
}
\description{
Wrapper function around \code{\link[YAPSA]{confIntExp}}, which is applies to
every signature or sample pair in a cohort. The extracted lower bound of the
confidence intervals are added to the input data which is reodered and melted
in order to prepare for visualization with ggplot2. The calculates of
confidence intervals is based on a profiling likelihood algorithm and the
wrapper calculates the data for the exposure contubution identefied with
INDEL singature decomposition and the usage of
\code{PCAWGValidID_absCutoffVector} data frame.
}
\details{
The function makes use of differnet YAPSA functions. For each of the above
stated cutoff vectors a per PID decompostion of the SNV and INDEL catalog is
calulated respectivly using \code{\link[YAPSA]{LCD_complex_cutoff_perPID}}.
In a next step, \code{\link[YAPSA]{variateExp}} which is a wrapper around
\code{\link[YAPSA]{confIntExp}} to compute confidenceintervals for a cohort
is used. A dataframe is returend with the upper and lower bounds of the
confidence intervals. In a last step
\code{\link[YAPSA]{plotExposuresConfidence_indel}} to plot the exposures to
extracted signatures including confidence intervals computed with e.g. by
\code{\link[YAPSA]{variateExp}}.
}
\examples{
data("GenomeOfNl_MutCat")
temp_list <- confidence_indel_only_calulation(
                        in_current_indel_df=MutCat_indel_df)
plot(temp_list$p_complete_PCAWG_ID)
head(temp_list$complete_PCAWG_ID)

}
