% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence.R
\name{variateExp}
\alias{variateExp}
\title{Wrapper to compute confidence intervals for a cohort}
\usage{
variateExp(
  in_catalogue_df,
  in_sig_df,
  in_exposures_df,
  in_sigLevel = 0.05,
  in_delta = 0.4,
  in_pdf = NULL
)
}
\arguments{
\item{in_catalogue_df}{Input numerical data frame of the mutational catalog
of the cohort to be analyzed.}

\item{in_sig_df}{Numerical data frame of the signatures used for analysis.}

\item{in_exposures_df}{Input numerical data frame of the exposures computed
for the cohort to be analyzed.}

\item{in_sigLevel}{Significance level, parameter passed to \link{confIntExp}.}

\item{in_delta}{Inflation parameter for the alternative model, parameter
passed on to \link{confIntExp}}

\item{in_pdf}{Probability distribution function, parameter passed on to
\link{confIntExp}, if NULL assumed to be normal distribution.}
}
\value{
A melted data frame.
}
\description{
Wrapper function around \link{confIntExp}, which is applied to every
signature/sample pair in a cohort. The extracted upper and lower bounds of
the confidence intervals are added to the input data which is reordered and
melted in order to prepare for visualization with ggplot2.
}
\examples{
 library(BSgenome.Hsapiens.UCSC.hg19)
 data(lymphoma_test)
 data(lymphoma_cohort_LCD_results)
 data(sigs)
 word_length <- 3
 temp_list <- create_mutation_catalogue_from_df(
   lymphoma_test_df,this_seqnames.field = "CHROM",
   this_start.field = "POS",this_end.field = "POS",
   this_PID.field = "PID",this_subgroup.field = "SUBGROUP",
   this_refGenome = BSgenome.Hsapiens.UCSC.hg19,
   this_wordLength = word_length)
 lymphoma_catalogue_df <- temp_list$matrix
 lymphoma_PIDs <- colnames(lymphoma_catalogue_df)
 data("lymphoma_cohort_LCD_results")
 lymphoma_exposures_df <-
   lymphoma_Nature2013_COSMIC_cutoff_exposures_df[,lymphoma_PIDs]
 lymphoma_sigs <- rownames(lymphoma_exposures_df)
 lymphoma_sig_df <- AlexCosmicValid_sig_df[,lymphoma_sigs]
 lymphoma_complete_df <- variateExp(in_catalogue_df = lymphoma_catalogue_df,
                                    in_sig_df = lymphoma_sig_df,
                                    in_exposures_df = lymphoma_exposures_df,
                                    in_sigLevel = 0.025, in_delta = 0.4)
 head(lymphoma_complete_df)
 lymphoma_complete_df$sample <-
   factor(lymphoma_complete_df$sample,
          levels = colnames(lymphoma_exposures_df)[
            order(colSums(lymphoma_exposures_df), decreasing = TRUE)])
 sig_colour_vector <- c("black", AlexCosmicValid_sigInd_df$colour)
 names(sig_colour_vector) <-
   c("total", as.character(AlexCosmicValid_sigInd_df$sig))
 ggplot(data = lymphoma_complete_df,
        aes(x = sample, y = exposure, fill = sig)) +
   geom_bar(stat = "identity") +
   geom_errorbar(aes(ymin = lower, ymax = upper), width = 0.2) +
   facet_wrap(~sig, nrow = nrow(lymphoma_exposures_df) + 1) +
   theme_grey() +
   theme(panel.border = element_rect(fill = NA, colour = "black"),
         strip.background = element_rect(colour = "black"),
         legend.position = "none") +
   scale_fill_manual(values = sig_colour_vector)
 
}
