% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedbaser.R
\name{bb_bed_text_search}
\alias{bb_bed_text_search}
\title{Search BED files by text}
\usage{
bb_bed_text_search(
  bedbase,
  query,
  genome = NULL,
  assay = NULL,
  limit = 10,
  offset = 0
)
}
\arguments{
\item{bedbase}{BEDbase() object}

\item{query}{character() keywords to search}

\item{genome}{character() (default NULL) genome to search}

\item{assay}{character() (default NULL) assay to search}

\item{limit}{integer(1) (default \code{10}) maximum number of results}

\item{offset}{integer(1) (default \code{0}) page offset of results}
}
\value{
\link[tibble:tibble]{tibble} of results
}
\description{
Return all available BED files ranked by relevance to the
keywords. Uses the \href{https://api.bedbase.org}{bedhost API} default of 10
records and an initial offset of 0.
}
\examples{
bedbase <- BEDbase()
bb_bed_text_search(bedbase, "hg38")

}
