% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgeR.R
\name{.edgeRBeads}
\alias{.edgeRBeads}
\title{Estimate edgeR dispersion parameters from the beads-only data using qCML}
\usage{
.edgeRBeads(object, threshold.cpm = 0, threshold.prevalence = 0)
}
\arguments{
\item{object}{\code{\link[PhIPData]{PhIPData}} object (can have actual serum
samples)}

\item{threshold.cpm}{CPM threshold to be considered present in a sample}

\item{threshold.prevalence}{proportion of beads-only samples that surpass
\code{threshold.cpm}.}
}
\value{
a DGEList object with common, trended, and tagwise dispersion
estimates
}
\description{
Wrapper function to estimate edgeR dispersion parameters from beads-only
samples. Peptides can be pre-filtered based on a minimum read count per
million (cpm) and the proportion of beads-only samples that surpass the cpm
threshold.
}
