% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment.R
\name{binaryPRC}
\alias{binaryPRC}
\title{Precision-recall curve for binary label prediction}
\usage{
binaryPRC(
  scores,
  labels,
  cutoff = NULL,
  cut_direction = ">=",
  add_cut1 = FALSE,
  empty_precision = 1
)
}
\arguments{
\item{scores}{Prediction score for each sample}

\item{labels}{True labels for each sample, e.g., from simulation}

\item{cutoff}{A vector of cutoffs; if NULL use all unique scores}

\item{cut_direction}{A string to compare with cutoff: >=, >, <=, <}

\item{add_cut1}{Logical value; if True, manually add a cutoff of 1}

\item{empty_precision}{Float value for default precision if no any recall}
}
\value{
A data.frame containing recall and precision values at various 
cutoffs.
}
\description{
Precision-recall curve for binary label prediction
}
\examples{
scores <- 1:10
labels <- c(0, 0, 0, 1, 0, 1, 0, 1, 1, 1)
binaryPRC(scores, labels)

# Extra arguments. 
binaryPRC(scores, labels, cutoff = seq(1, 10, by = 2))
binaryPRC(scores, labels, cut_direction = ">")
binaryPRC(scores, labels, add_cut1 = TRUE)

}
