###### testing simulations #######

test_that("get_partial with invalid control", {
  expect_error(gen_partial(),
               regexp = "object 'delta' not found")
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta,
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "object 'delta' not found")
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = 0,
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "delta must have length > 1")
  expect_no_error(gen_partial(control = list(N_biorep = 3, 
                                             N_techrep = 3, 
                                             N_cell = 50, 
                                             delta = c(0,2),
                                             sigma_bio = 0.2, 
                                             sigma_tech = 0.05, 
                                             offset = 1,
                                             prior_alpha_p_M = 1.7,
                                             prior_alpha_p_SD = 0.5,
                                             prior_kappa_mu_M = 1.7,
                                             prior_kappa_mu_SD = 0.5,
                                             prior_kappa_sigma_M = 0,
                                             prior_kappa_sigma_SD = 0.3)))
  
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 3,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "offset must be between 1 and length of delta")
  
  expect_error(gen_partial(control = NA),
               regexp = "control must be list")
  expect_error(gen_partial(control = NULL),
               regexp = "control is missing or NULL")
  expect_error(gen_partial(control = NA),
               regexp = "control must be list")
  
  
  
  expect_no_error(gen_partial(control = list(N_biorep = 3, 
                                             N_techrep = 3, 
                                             N_cell = 50, 
                                             delta = c(0,2),
                                             sigma_bio = 0.2, 
                                             sigma_tech = 0.05, 
                                             offset = 1,
                                             prior_alpha_p_M = -1.7,
                                             prior_alpha_p_SD = 0.5,
                                             prior_kappa_mu_M = 1.7,
                                             prior_kappa_mu_SD = 0.5,
                                             prior_kappa_sigma_M = 0,
                                             prior_kappa_sigma_SD = 0.3)))
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = -0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "prior_alpha_p_SD must be >0")
  expect_no_error(gen_partial(control = list(N_biorep = 3, 
                                             N_techrep = 3, 
                                             N_cell = 50, 
                                             delta = c(0,2),
                                             sigma_bio = 0.2, 
                                             sigma_tech = 0.05, 
                                             offset = 1,
                                             prior_alpha_p_M = 1.7,
                                             prior_alpha_p_SD = 0,
                                             prior_kappa_mu_M = 1.7,
                                             prior_kappa_mu_SD = 0.5,
                                             prior_kappa_sigma_M = 0,
                                             prior_kappa_sigma_SD = 0.3)))
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = -Inf,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "prior_alpha_p_SD must be >0")
  
  
  
  expect_no_error(gen_partial(control = list(N_biorep = 3, 
                                             N_techrep = 3, 
                                             N_cell = 50, 
                                             delta = c(0,2),
                                             sigma_bio = 0.2, 
                                             sigma_tech = 0.05, 
                                             offset = 1,
                                             prior_alpha_p_M = 1.7,
                                             prior_alpha_p_SD = 0.5,
                                             prior_kappa_mu_M = -1.7,
                                             prior_kappa_mu_SD = 0.5,
                                             prior_kappa_sigma_M = 0,
                                             prior_kappa_sigma_SD = 0.3)))
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = -0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "prior_kappa_mu_SD must be >0")
  expect_no_error(gen_partial(control = list(N_biorep = 3, 
                                             N_techrep = 3, 
                                             N_cell = 50, 
                                             delta = c(0,2),
                                             sigma_bio = 0.2, 
                                             sigma_tech = 0.05, 
                                             offset = 1,
                                             prior_alpha_p_M = 1.7,
                                             prior_alpha_p_SD = 0.5,
                                             prior_kappa_mu_M = 1.7,
                                             prior_kappa_mu_SD = 0,
                                             prior_kappa_sigma_M = 0,
                                             prior_kappa_sigma_SD = 0.3)))
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = -Inf,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "prior_kappa_mu_SD must be >0")
  
  
  expect_no_error(gen_partial(control = list(N_biorep = 3, 
                                             N_techrep = 3, 
                                             N_cell = 50, 
                                             delta = c(0,2),
                                             sigma_bio = 0.2, 
                                             sigma_tech = 0.05, 
                                             offset = 1,
                                             prior_alpha_p_M = 1.7,
                                             prior_alpha_p_SD = 0.5,
                                             prior_kappa_mu_M = .7,
                                             prior_kappa_mu_SD = 0.5,
                                             prior_kappa_sigma_M = 0,
                                             prior_kappa_sigma_SD = 0.3)))
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = -1,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "prior_kappa_sigma_M must be >0")
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = Inf,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "prior_kappa_sigma_M is infinite")
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = -Inf,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "prior_kappa_sigma_M must be >0")
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 1.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = NA,
                                          prior_kappa_sigma_SD = 0.3)),
               regexp = "prior_kappa_sigma_M must be numeric")
  
  
  expect_no_error(gen_partial(control = list(N_biorep = 3, 
                                             N_techrep = 3, 
                                             N_cell = 50, 
                                             delta = c(0,2),
                                             sigma_bio = 0.2, 
                                             sigma_tech = 0.05, 
                                             offset = 1,
                                             prior_alpha_p_M = 1.7,
                                             prior_alpha_p_SD = 0.5,
                                             prior_kappa_mu_M = 0.7,
                                             prior_kappa_mu_SD = 0.5,
                                             prior_kappa_sigma_M = 0,
                                             prior_kappa_sigma_SD = 0.3)))
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 0.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = -0.3)),
               regexp = "prior_kappa_sigma_SD must be >0")
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 0.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = -Inf)),
               regexp = "prior_kappa_sigma_SD must be >0")
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 0.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = Inf)),
               regexp = "prior_kappa_sigma_SD is infinite")
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 0.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = NA)),
               regexp = "prior_kappa_sigma_SD must be numeric")
  
  
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = 1.7,
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 0.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = c(0, 1))),
               regexp = "prior_kappa_sigma_SD must have length of 1")
  expect_error(gen_partial(control = list(N_biorep = 3, 
                                          N_techrep = 3, 
                                          N_cell = 50, 
                                          delta = c(0,2),
                                          sigma_bio = 0.2, 
                                          sigma_tech = 0.05, 
                                          offset = 1,
                                          prior_alpha_p_M = c(1.7, 2),
                                          prior_alpha_p_SD = 0.5,
                                          prior_kappa_mu_M = 0.7,
                                          prior_kappa_mu_SD = 0.5,
                                          prior_kappa_sigma_M = 0,
                                          prior_kappa_sigma_SD = 0)),
               regexp = "prior_alpha_p_M must have length of 1")
})

test_that("get_full with simple controls", {
  expect_no_error(gen_full())
  expect_error(gen_full(control = NA),
               regexp = "control must be list")
  expect_error(gen_full(control = NULL),
               regexp = "control is missing or NULL")
  expect_error(gen_full(control = NA),
               regexp = "control must be list")
})

test_that("get_full with wrong control entries", {
  expect_error(gen_full(control = list(N_biorep = NA, 
                                       N_techrep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_biorep is NA")
  expect_error(gen_full(control = list(N_biorep = NULL, 
                                       N_techrep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_biorep is missing or NULL")
  expect_error(gen_full(control = list(N_techrep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_biorep is missing or NULL")
  expect_error(gen_full(control = list(N_biorep = -1, 
                                       N_techrep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_biorep must be >0")
  expect_error(gen_full(control = list(N_biorep = 1.5, 
                                       N_techrep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_biorep must be an integer")
  expect_error(gen_full(control = list(N_biorep = Inf, 
                                       N_techrep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_biorep is infinite")
  
  
  
  expect_error(gen_full(control = list(N_techrep = NA, 
                                       N_biorep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_techrep is NA")
  expect_error(gen_full(control = list(N_techrep = NULL, 
                                       N_biorep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_techrep is missing or NULL")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_techrep is missing or NULL")
  expect_error(gen_full(control = list(N_techrep = -1, 
                                       N_biorep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_techrep must be >0")
  expect_error(gen_full(control = list(N_techrep = 1.5, 
                                       N_biorep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_techrep must be an integer")
  expect_error(gen_full(control = list(N_techrep = Inf, 
                                       N_biorep = 3,
                                       N_cell = 50,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_techrep is infinite")
  
  
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_techrep = 3,
                                       N_cell = NA, 
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_cell is NA")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_techrep = 3,
                                       N_cell = NULL,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_cell is missing or NULL")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_techrep = 3,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_cell is missing or NULL")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_techrep = 3,
                                       N_cell = -1,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_cell must be >0")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_techrep = 3,
                                       N_cell = 1.5,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_cell must be an integer")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_techrep = 3,
                                       N_cell = Inf,
                                       N_group = 5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "N_cell is infinite")
  
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_tech = 3,
                                       N_cell = 10, 
                                       N_group = NA,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "control has missing elements")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_tech = 3,
                                       N_cell = 10,
                                       N_group = NULL,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "control has missing elements")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_tech = 3,
                                       N_cell = 10,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "control has missing elements")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_tech = 3,
                                       N_cell = 10,
                                       N_group = -1,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "control has missing elements")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_tech = 3,
                                       N_cell = 10,
                                       N_group = 1.5,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "control has missing elements")
  expect_error(gen_full(control = list(N_biorep = 3,
                                       N_tech = 3,
                                       N_cell = 10,
                                       N_group = Inf,
                                       prior_alpha_p_M = 1.7,
                                       prior_alpha_p_SD = 1,
                                       prior_kappa_mu_M = 1.7,
                                       prior_kappa_mu_SD = 1,
                                       prior_kappa_sigma_M = 0,
                                       prior_kappa_sigma_SD = 1,
                                       prior_sigma_bio_M = 0,
                                       prior_sigma_bio_SD = 1,
                                       prior_sigma_tech_M = 0,
                                       prior_sigma_tech_SD = 1,
                                       prior_mu_group_M = 0,
                                       prior_mu_group_SD = 1)),
               regexp = "control has missing elements")
})
