% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genome_assembly.R
\name{get_genome_stats}
\alias{get_genome_stats}
\title{Get summary statistics for genomes on NCBI using the NCBI Datasets API}
\usage{
get_genome_stats(taxon = NULL, filters = NULL)
}
\arguments{
\item{taxon}{Taxon for which summary statistics will be
retrieved, either as a character scalar (e.g., "brassicaceae") or
as a numeric scalar representing NCBI Taxonomy ID (e.g., 3700).}

\item{filters}{(optional) A list of filters to use when querying the API
in the form of key-value pairs, with keys in list names and values in list
elements (e.g., \code{list(filters.reference_only = "true")}, see
examples for details).}
}
\value{
A data frame with the following variables:
\describe{
\item{accession}{character, accession number.}
\item{source}{character, data source.}
\item{species_taxid}{numeric, NCBI Taxonomy ID.}
\item{species_name}{character, species' scientific name.}
\item{species_common_name}{character, species' common name.}
\item{species_ecotype}{character, species' ecotype.}
\item{species_strain}{character, species' strain.}
\item{species_isolate}{character, species' isolate.}
\item{species_cultivar}{character, species' cultivar.}
\item{assembly_level}{factor, assembly level ("Complete", "Chromosome", "Scaffold", or "Contig").}
\item{assembly_status}{character, assembly status.}
\item{assembly_name}{character, assembly name.}
\item{assembly_type}{character, assembly type.}
\item{submission_date}{character, submission date (YYYY-MM-DD).}
\item{submitter}{character, submitter name.}
\item{sequencing_technology}{character, sequencing technology.}
\item{atypical}{logical, indicator of wheter the genome is atypical.}
\item{refseq_category}{character, RefSeq category.}
\item{chromosome_count}{numeric, number of chromosomes.}
\item{sequence_length}{numeric, total sequence length.}
\item{ungapped_length}{numeric, ungapped sequence length.}
\item{contig_count}{numeric, number of contigs.}
\item{contig_N50}{numeric, contig N50.}
\item{contig_L50}{numeric, contig L50.}
\item{scaffold_N50}{numeric, contig N50.}
\item{scaffold_L50}{numeric, contig L50.}
\item{GC_percent}{numeric, GC percentage (0-100).}
\item{annotation_provider}{character, name of annotation provider.}
\item{annotation_release_date}{character, annotation release date (YYYY-MM-DD).}
\item{gene_count_total}{numeric, total number of genes.}
\item{gene_count_coding}{numeric, number of protein-coding genes.}
\item{gene_count_noncoding}{numeric, number of non-coding genes.}
\item{gene_count_pseudogene}{numeric, number of pseudogenes.}
\item{gene_count_other}{numeric, number of other genes.}
\item{CC_ratio}{numeric, ratio of the number of contigs to the number of chromosomes.}
}
}
\description{
Get summary statistics for genomes on NCBI using the NCBI Datasets API
}
\details{
Possible filters for the \strong{filters} parameter can be accessed
at https://www.ncbi.nlm.nih.gov/datasets/docs/v2/reference-docs/rest-api/#get-/genome/taxon/-taxons-/dataset_report.
}
\examples{
# Example 1: Search for A. thaliana genomes by tax ID
ex1 <- get_genome_stats(taxon = 3702)

# Example 2: Search for A. thaliana genomes by name
ex2 <- get_genome_stats(taxon = "Arabidopsis thaliana")

# Example 3: Search for chromosome-level Brassicaeae genomes
ex3 <- get_genome_stats(
    taxon = "brassicaceae",
    filters = list(filters.assembly_level = "chromosome")
)

}
