% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_import.R
\name{read_busco}
\alias{read_busco}
\title{Read and parse BUSCO's summary report}
\usage{
read_busco(result_dir = NULL)
}
\arguments{
\item{result_dir}{Path to the directory where BUSCO results are stored.
This function will look for the short_summary* file (single run) or
short_summary* file (batch mode).}
}
\value{
A data frame with the following variables:
\describe{
\item{Class}{BUSCO class. One of \strong{Complete_SC},
\strong{Complete_duplicate}, \strong{Fragmented}, or
\strong{Missing}}
\item{Frequency}{Frequency of BUSCOs in each class. If BUSCO was run
in batch mode, this variable will contain relative
frequencies. If BUSCO was run for a single file,
it will contain absolute frequencies.}
\item{Lineage}{Name of the lineage dataset used.}
\item{File (batch mode only)}{Name of the input FASTA file.}
}
}
\description{
Read and parse BUSCO's summary report
}
\examples{
result_dir <- system.file("extdata", package = "cogeqc")
df <- read_busco(result_dir)
}
