% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeBySig.R
\name{mergeBySig}
\alias{mergeBySig}
\alias{mergeBySig,GenomicRanges-method}
\alias{mergeBySig,RangedSummarizedExperiment-method}
\title{Merge overlapping ranges based on p-values}
\usage{
mergeBySig(x, ...)

\S4method{mergeBySig}{GenomicRanges}(
  x,
  df = NULL,
  logfc = "logFC",
  pval = "P",
  cpm = "logCPM",
  inc_cols,
  p_adj_method = "fdr",
  alpha = 0.05,
  method = c("combine", "best", "minimal"),
  merge_within = 1L,
  ignore_strand = TRUE,
  min_win = 1,
  ...
)

\S4method{mergeBySig}{RangedSummarizedExperiment}(
  x,
  df = NULL,
  logfc = "logFC",
  pval = "P",
  cpm = "logCPM",
  inc_cols,
  p_adj_method = "fdr",
  alpha = 0.05,
  method = c("combine", "best", "minimal"),
  merge_within = 1L,
  ignore_strand = TRUE,
  ...
)
}
\arguments{
\item{x}{GenomicRanges object}

\item{...}{Passed to all csaw functions being wrapped}

\item{df}{data.frame with results of differential binding analysis performed
using a sliding window strategy. If not provided, the columns in the
\code{mcols()} element of \code{x} will be used}

\item{logfc, pval, cpm}{Column names for the values holding window specific
estimates of change in binding (logfc), overall signal intensity (cpm) and
the significance from statistical testing (pval)}

\item{inc_cols}{(Optional) Character vector of any additional columns in
\code{df} to return}

\item{p_adj_method}{One of \code{p.adjust.methods}}

\item{alpha}{Significance threshold to apply during internal calculations}

\item{method}{Shorthand versions for which \code{csaw} strategy to use for
merging windows. Choose from 'combine' (\link[csaw]{combineTests}), 'best'
(\link[csaw]{getBestTest}) or 'minimal' (\link[csaw]{minimalTests}).}

\item{merge_within}{Merge any non-overlapping windows within this distance}

\item{ignore_strand}{Passed internally to \link[GenomicRanges]{reduce} and
\link[GenomicRanges]{findOverlaps}}

\item{min_win}{Only keep merged windows derived from at least this number}
}
\value{
A GenomicRanges object with overlapping ranges from the original object
merged and representative values returned. The range corresponding to the
representative values is also returned
}
\description{
Merge overlapping windows using p-values from significance
testing
}
\details{
When using sliding windows to test for differential signal, overlapping
windows can be merged based on the significance of results.
\code{mergeBySig()} is a wrapper to the functions \link[csaw]{combineTests},
\link[csaw]{getBestTest} and \link[csaw]{minimalTests}, using each
function's approach to finding a representative window. The returned object
differs from those returned by the original functions in that the
description of windows as 'up', 'down' or mixed is omitted and the genomic
range corresponding to the representative window is also returned. Column
names also correspond to those in the original object.

An additional column with adjusted p-values is returned. This column retains
the same name as the original but with the suffix '_*' added where the
p-value adjustment method is added after the underscore.
}
\examples{
x <- GRanges(c("chr1:1-10", "chr1:6-15", "chr1:51-60"))
set.seed(1001)
df <- DataFrame(logFC = rnorm(3), logCPM = rnorm(3,8), p = rexp(3, 10))
mcols(x) <- df
mergeBySig(x, pval = "p", method = "combine")
mergeBySig(x, pval = "p", method = "best")
mergeBySig(x, pval = "p", method = "min")

}
