% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_graph.R
\name{cell_type_layers}
\alias{cell_type_layers}
\title{Determines the layer on which a phenotype resides.}
\usage{
cell_type_layers(phen)
}
\arguments{
\item{phen}{A string vector of phenotype or cell population name labels.}
}
\value{
A numeric vector with the same length as \code{phen} indicating which
   layer each phenotype resides on.
}
\description{
Determines the layer on which the given phenotypes reside.
}
\details{
Given a vector of phenotypes, returns an equal length vector of
   the number of markers in each phenotype.
}
\examples{

   phen <- c('A+B+C-D++', 'A+B-', '', 'B++D-E+')
   cell_type_layers(phen)

}
\seealso{
\code{\link[flowGraph]{get_phen_list}}
   \code{\link[flowGraph]{get_phen_meta}}
}
