% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_flowgraph_features.R
\name{fg_feat_edge_specenr}
\alias{fg_feat_edge_specenr}
\title{Generates the SpecEnr edge feature.}
\usage{
fg_feat_edge_specenr(fg, no_cores = 1, overwrite = FALSE)
}
\arguments{
\item{fg}{flowGraph object.}

\item{no_cores}{An integer indicating how many cores to parallelize on.}

\item{overwrite}{A logical variable indicating whether to
overwrite the existing proportion edge feature if it exists.}
}
\value{
flowGraph object containing the proportion edge feature.
}
\description{
Generates the SpecEnr edge feature and returns it
 inside the flowGraph object.
}
\details{
Given a flowGraph object, \code{fg_feat_edge_SpecEnr} returns the same
 flowGraph object with an additional SpecEnr and expected proportions
 \code{expect_prop} \code{edge}
 feature and its meta data. The expected proportions edge feature is
 calculated by taking the ratio of the child nodes' (e.g. A+B+)
 expected proportion value over
 its parent nodes' (e.g. A+) actual proportion value.
 The SpecEnr feature is the actual over expected proportion ratio, logged.
 The edge feature matrix has column names <from>_<to> e.g. A+_A+B+.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 fg <- fg_feat_edge_specenr(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_feat_node_prop}}
 \code{\link[flowGraph]{fg_feat_node_specenr}}
 \code{\link[flowGraph]{fg_add_feature}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_rm_feature}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
}
