% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_GatingSet.R
\name{gs_update_channels}
\alias{gs_update_channels}
\alias{updateChannels}
\title{Update the channel information of a GatingSet (c++ part)}
\usage{
gs_update_channels(gs, map, all = TRUE)
}
\arguments{
\item{gs}{a GatingSet object}

\item{map}{\code{data.frame} contains the mapping from old (case insensitive) to new channel names
Note: Make sure to remove the '<' or '>' characters from 'old` name because the API tries 
      to only look at the raw channel name so that the gates with both prefixed and non-prefixed names could be updated.}

\item{all}{\code{logical} whether to update the flow data as well}
}
\value{
when 'all' is set to TRUE, it returns a new GatingSet but it still shares the same underling c++ tree structure with the original GatingSet                                  
 otherwise it returns nothing (less overhead.)
}
\description{
It updates the channels stored in gates,compensations and transformations
based on given mapping between the old and new channel names.
}
\examples{
\dontrun{
  ##this will update both "Qdot 655-A" and "<Qdot 655-A>"
 gs <- gs_update_channels(gs, map = data.frame(old = c("Qdot 655-A")
                                         , new = c("QDot 655-A")
                                         )
                     )  
}
}
