% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dx.R
\name{gDNAdx}
\alias{gDNAdx}
\alias{plot,gDNAx,ANY-method}
\alias{plotAlnOrigins}
\alias{plotFrgLength}
\title{Calculate gDNA diagnostics}
\usage{
gDNAdx(
  bfl,
  txdb,
  singleEnd,
  strandMode,
  stdChrom = TRUE,
  yieldSize = 100000L,
  exonsBy = c("gene", "tx"),
  minnaln = 2e+05,
  useRMSK = TRUE,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)

\S4method{plot}{gDNAx,ANY}(x, group = 1L, labelpoints = FALSE, ...)

plotAlnOrigins(x, group = 1L)

plotFrgLength(x)
}
\arguments{
\item{bfl}{A \code{BamFile} or \code{BamFileList} object, or a character
string vector of BAM filenames.}

\item{txdb}{A character string of a \code{TxDb} package, or a \code{TxDb}
object, with gene and transcript annotations. For accurate calculations, it
is important that the version of these annotations matches the version of
the annotations used to inform the alignment of spliced reads, by the
short-read aligner software that generated the input BAM files.}

\item{singleEnd}{(missing by default) Logical value indicating if reads are
single (\code{TRUE}) or paired-end (\code{FALSE}). When this argument is
missing (default), its value will be estimated automatically from the BAM
files.}

\item{strandMode}{(missing by default) Integer value either 0, 1, 2 or
\code{NA}, indicating how the strand of a pair of read alignments should
be inferred from the strand of the first and last alignments in the pair.
See the \code{\link[GenomicAlignments:GAlignmentPairs-class]{GAlignmentPairs}}
class for further details. If \code{singleEnd = TRUE}, then \code{strandMode}
is ignored. For unstranded RNA-seq libraries, use \code{NA}. When this
argument is missing (default), its value will be estimated automatically from
the BAM files.}

\item{stdChrom}{(Default TRUE) Logical value indicating whether only
alignments in the 'standard chromosomes' should be used. Consult the help
page of the function \code{\link[GenomeInfoDb]{keepStandardChromosomes}}
from the package \code{GenomeInfoDb} for further information.}

\item{yieldSize}{(Default 1e5) Number of records to read from each input BAM
file to calculate the diagnostics.}

\item{exonsBy}{(Default 'gene') Character string, either \code{gene} or
\code{tx}, respectively specifying whether exon annotations should be
grouped by gene or by transcript, in the estimation of strandedness values.
Consult the help page of the function \code{\link[GenomicFeatures]{exonsBy}()}
from the package \code{GenomicFeatures} for further information.}

\item{minnaln}{(Default 200000) Minimum number of read alignments overlapping
exonic regions considered necessary for a reliable estimation of strandedness
values. A warning message is given if the number of such available alignments
is smaller than the one given through this parameter. This parameter only
applies if no argument is given for the \code{strandMode} parameter.}

\item{useRMSK}{(Default TRUE) Logical value indicating if RepeatMasker
annotations should be used when building intergenic and intronic genomic
ranges for gDNA estimation. If \code{useRMSK=TRUE}, then UCSC RepeatMasker
annotations will be downloaded as \code{\link[AnnotationHub]{AnnotationHub}}
resources, and intergenic and intronic genomic ranges will exclude them.}

\item{verbose}{(Default TRUE) Logical value indicating if progress should be
reported through the execution of the code.}

\item{BPPARAM}{An object of a
\code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}} subclass
to configure the parallel execution of the code. By default, a
\code{\link[BiocParallel:SerialParam-class]{SerialParam}} object is used, which does
not use any parallelization, with the flag \code{progress=TRUE} to show
progress through the calculations.}

\item{x}{A 'gDNAx' object.}

\item{group}{A string character vector or a factor, with as many values
as BAM files analyzed in 'x', whose values define groups among those
BAM files.}

\item{labelpoints}{(Default FALSE) A logical indicator that labels points
in those plots where each point represents a BAM file. Labels correspond
to the index number of the BAM file in 'x'.}

\item{...}{Named arguments to be passed to \code{\link[base:plot]{plot}}.}
}
\value{
A \code{\link{gDNAx}} object.
}
\description{
Calculate diagnostics for assessing the presence of genomic DNA (gDNA)
in RNA-seq data over a subset of the alignments in the input BAM files.

Plot diagnostics calculated with gDNAdx()

Using the output from gDNAdx(), plot the genomic origin of the alignments.

Plot fragments length distributions estimated with gDNAdx()
}
\examples{
library(gDNAinRNAseqData)

library(TxDb.Hsapiens.UCSC.hg38.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene

# Retrieving BAM files
bamfiles <- LiYu22subsetBAMfiles()
bamfiles <- bamfiles[c(1,4,7)] # using a subset of samples

# Getting information about the gDNA concentrations of each BAM file
pdat <- LiYu22phenoData(bamfiles)

gdnax <- gDNAdx(bamfiles, txdb, singleEnd=FALSE, strandMode=NA)
gdnax

# plot gDNA diagnostic measures
plot(gdnax, group=pdat$gDNA, pch=19)

# plot origin of alignments per sample
plotAlnOrigins(gdnax, group=pdat$gDNA)

# plot fragments length distributions
plotFrgLength(gdnax)

}
