% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reexports.R
\docType{import}
\name{reexports}
\alias{reexports}
\alias{\%<+\%}
\alias{td_filter}
\alias{td_mutate}
\alias{td_unnest}
\alias{\%>\%}
\alias{rtree}
\alias{read.tree}
\alias{groupOTU}
\alias{groupClade}
\alias{nodeid}
\alias{nodelab}
\alias{MRCA}
\alias{collapse}
\alias{fortify}
\alias{ggplot}
\alias{xlim}
\alias{theme}
\alias{ggsave}
\alias{aes}
\alias{geom_text}
\alias{geom_label}
\alias{geom_point}
\alias{guide_legend}
\alias{scale_colour_manual}
\alias{scale_color_manual}
\alias{scale_fill_manual}
\alias{scale_x_continuous}
\alias{margin}
\alias{arrow}
\alias{unit}
\alias{plot_list}
\alias{identify}
\title{Objects exported from other packages}
\examples{
nwk <- system.file("extdata", "sample.nwk", package="treeio")
tree <- read.tree(nwk)
p <- ggtree(tree)
dd <- data.frame(taxa=LETTERS[1:13],
                   place=c(rep("GZ", 5), rep("HK", 3), rep("CZ", 4), NA),
             value=round(abs(rnorm(13, mean=70, sd=10)), digits=1))
row.names(dd) <- NULL
p \%<+\% dd + geom_text(aes(color=place, label=label), hjust=-0.5)
}
\keyword{internal}
\description{
These objects are imported from other packages. Follow the links
below to see their documentation.

\describe{
  \item{ape}{\code{\link[ape]{read.tree}}, \code{\link[ape]{rtree}}}

  \item{aplot}{\code{\link[aplot]{plot_list}}}

  \item{dplyr}{\code{\link[dplyr:compute]{collapse}}}

  \item{ggfun}{\code{\link[ggfun:attacher]{\%<+\%}}, \code{\link[ggfun:reexports]{identify}}, \code{\link[ggfun]{td_filter}}, \code{\link[ggfun]{td_mutate}}, \code{\link[ggfun]{td_unnest}}}

  \item{ggplot2}{\code{\link[ggplot2]{aes}}, \code{\link[ggplot2]{fortify}}, \code{\link[ggplot2:geom_text]{geom_label}}, \code{\link[ggplot2]{geom_point}}, \code{\link[ggplot2]{geom_text}}, \code{\link[ggplot2]{ggplot}}, \code{\link[ggplot2]{ggsave}}, \code{\link[ggplot2]{guide_legend}}, \code{\link[ggplot2:element]{margin}}, \code{\link[ggplot2:scale_manual]{scale_color_manual}}, \code{\link[ggplot2:scale_manual]{scale_colour_manual}}, \code{\link[ggplot2:scale_manual]{scale_fill_manual}}, \code{\link[ggplot2:scale_continuous]{scale_x_continuous}}, \code{\link[ggplot2]{theme}}, \code{\link[ggplot2:lims]{xlim}}}

  \item{grid}{\code{\link[grid]{arrow}}, \code{\link[grid]{unit}}}

  \item{magrittr}{\code{\link[magrittr:pipe]{\%>\%}}}

  \item{tidytree}{\code{\link[tidytree]{groupClade}}, \code{\link[tidytree]{groupOTU}}, \code{\link[tidytree]{MRCA}}, \code{\link[tidytree]{nodeid}}, \code{\link[tidytree]{nodelab}}}
}}

