% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildNetwork.R
\name{buildNetwork}
\alias{buildNetwork}
\title{Build Edit Distance Network}
\usage{
buildNetwork(
  input.data = NULL,
  input.sequences = NULL,
  seq_col = NULL,
  v_col = NULL,
  j_col = NULL,
  threshold = 2,
  filter.v = FALSE,
  filter.j = FALSE,
  ids = NULL,
  output = c("edges", "sparse"),
  weight = c("dist", "binary")
)
}
\arguments{
\item{input.data}{`data.frame`/`tibble` with sequence & metadata
(optional - omit if you supply `sequences` directly).}

\item{input.sequences}{Character vector of sequences **or** column name
inside `input.data`. Ignored when `NULL` and `seq_col` is non-`NULL`.}

\item{seq_col, v_col, j_col}{Column names to use when `input.data` is given. 
By default the function looks for common AIRR names (`junction_aa`, 
`cdr3`, `v_call`, `j_call`).}

\item{threshold}{>= 1 for absolute distance **or** 0 < x <= 1 for relative.}

\item{filter.v, filter.j}{Logical; require identical V/J when `TRUE`.}

\item{ids}{Optional character labels; recycled from row-names if missing.}

\item{output}{`"edges"` (default) or `"sparse"` - return an edge-list
`data.frame` **or** a symmetric `Matrix::dgCMatrix` adjacency matrix.}

\item{weight}{`"dist"` (store the edit distance) **or** `"binary"`
(all edges get weight 1). Ignored when `output = "edges"`.}
}
\value{
edge-list `data.frame` **or** sparse adjacency `dgCMatrix`
}
\description{
Build Edit Distance Network
}
\examples{
data(immapex_example.data)

# Build Edge List
edges <- buildNetwork(input.data = immapex_example.data[["AIRR"]],
                      seq_col    = "junction_aa",
                      threshold  = 0.9,     
                      filter.v   = TRUE)

}
