% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{gini_coef}
\alias{gini_coef}
\title{Gini Coefficient of Abundance Inequality}
\usage{
gini_coef(cnt)
}
\arguments{
\item{cnt}{Numeric vector of non-negative counts (one entry per clone/
residue/OTU).  Zero counts are ignored.}
}
\value{
A numeric value in [0, 1]. Returns `0` if there is only one
  category.
}
\description{
Calculates the Gini coefficient, a measure of inequality, for a vector
of clone/sequence counts. It ranges from 0 (perfect equality) to nearly 1
(maximal inequality).
}
\details{
\deqn{G = \frac{\sum_{i=1}^{S} (2i - S - 1) n_i}{S \sum_{i=1}^{S} n_i}}

where *n*i are the counts of each of the *S* categories,
sorted in non-decreasing order.
}
\examples{
# High inequality
gini_coef(c(100, 1, 1, 1))
# Perfect equality
gini_coef(c(10, 10, 10, 10))
}
\seealso{
[gini_simpson()]
}
