% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCDR.R
\name{inferCDR}
\alias{inferCDR}
\title{Infer CDR-loop segments from V-gene calls}
\usage{
inferCDR(
  input.data,
  reference,
  chain = "TRB",
  technology = c("TenX", "AIRR", "Adaptive", "Omniscope"),
  sequence.type = c("aa", "nt"),
  sequences = c("CDR1", "CDR2"),
  verbose = TRUE
)
}
\arguments{
\item{input.data}{Data frame output of \code{\link{formatGenes}}}

\item{reference}{IMGT reference sequences from \code{\link{getIMGT}}}

\item{chain}{Sequence chain to access, like \strong{TRB} or \strong{IGH}}

\item{technology}{The sequencing technology employed - \strong{TenX}, 
\strong{Adaptive}, or \strong{AIRR}}

\item{sequence.type}{Type of sequence - \strong{aa} for amino acid or 
\strong{nt} for nucleotide}

\item{sequences}{The specific regions of the CDR loop to get from the data, 
such as \strong{CDR1}.}

\item{verbose}{Logical. If `TRUE` (default), prints a progress message.}
}
\value{
A data frame with the new columns of CDR sequences added.
}
\description{
Use this isolate sequences from the CDR loop using
the V gene annotation. When there are multiple 
V gene matches for a single gene, the first allelic 
sequence is used.
}
\examples{
 \dontrun{
# Getting the Sequence Reference
data(immapex_example.data)
TRBV_aa <- getIMGT(species = "human",
                   chain = "TRB",
                   frame = "inframe",
                   region = "v",
                   sequence.type = "aa") 
                    
# Ensuring sequences are formatted to IMGT                   
TenX_formatted <- formatGenes(immapex_example.data[["TenX"]],
                              region = "v",
                              technology = "TenX")
             
# Inferring CDR loop elements           
TenX_formatted <- inferCDR(TenX_formatted,
                           chain = "TRB", 
                           reference = TRBV_aa,
                           technology = "TenX", 
                           sequence.type = "aa",
                           sequences = c("CDR1", "CDR2"))
}
                            
}
