% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatecc.R
\docType{methods}
\name{estimatecc}
\alias{estimatecc}
\title{Estimate cell composition from DNAm data}
\usage{
estimatecc(object, find_dmrs_object = NULL, verbose = TRUE,
  epsilon = 0.01, max_iter = 100, take_intersection = FALSE,
  include_cpgs = FALSE, include_dmrs = TRUE,
  init_param_method = "random", a0init = NULL, a1init = NULL,
  sig0init = NULL, sig1init = NULL, tauinit = NULL, demo = FALSE)
}
\arguments{
\item{object}{an object can be a \code{RGChannelSet}, 
\code{GenomicMethylSet} or \code{BSseq} object}

\item{find_dmrs_object}{If the user would like to supply 
different differentially methylated regions, they can 
use the output from the \code{find_dmrs} function 
to supply different regions to \code{estimatecc}.}

\item{verbose}{TRUE/FALSE argument specifying if verbose
messages should be returned or not. Default is TRUE.}

\item{epsilon}{Threshold for EM algorithm to check
for convergence. Default is 0.01.}

\item{max_iter}{Maximum number of iterations for EM
algorithm. Default is 100 iterations.}

\item{take_intersection}{TRUE/FALSE asking if only the CpGs 
included in \code{object} should be used to find DMRs. 
Default is FALSE.}

\item{include_cpgs}{TRUE/FALSE. Should individual CpGs
be returned. Default is FALSE.}

\item{include_dmrs}{TRUE/FALSE. Should differentially 
methylated regions be returned. Default is TRUE.}

\item{init_param_method}{method to initialize parameter estimates.
Choose between "random" (randomly sample) or "known_regions"
(uses unmethyalted and methylated regions that were identified
based on Reinus et al. (2012) cell sorted data.).
Defaults to "random".}

\item{a0init}{Default NULL. Initial mean 
methylation level in unmethylated regions}

\item{a1init}{Default NULL. Initial mean 
methylation level in methylated regions}

\item{sig0init}{Default NULL. Initial var 
methylation level in unmethylated regions}

\item{sig1init}{Default NULL. Initial var 
methylation level in methylated regions}

\item{tauinit}{Default NULL. Initial var 
for measurement error}

\item{demo}{TRUE/FALSE. Should the function 
be used in demo mode to shorten examples in 
package. Defaults to FALSE.}
}
\value{
A object of the class \code{estimatecc} that 
contains information about the cell composition 
estimation (in the \code{summary} slot) and 
the cell composition estimates themselves 
(in the \code{cell_counts} slot).
}
\description{
Estimate cell composition from DNAm data
}
\examples{
# This is a reduced version of the FlowSorted.Blood.450k 
# dataset available by using BiocManager::install("FlowSorted.Blood.450k),
# but for purposes of the example, we use the smaller version 
# and we set \\code{demo=TRUE}. For any case outside of this example for 
# the package, you should set \\code{demo=FALSE} (the default). 

dir <- system.file("data", package="methylCC")
files <- file.path(dir, "FlowSorted.Blood.450k.sub.RData") 
if(file.exists(files)){
    load(file = files)

    set.seed(12345)
    est <- estimatecc(object = FlowSorted.Blood.450k.sub, demo = TRUE) 
    cell_counts(est)
 }   

}
