% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeRMRanges.R
\name{makeRMRanges}
\alias{makeRMRanges}
\alias{makeRMRanges,GRanges,GRanges-method}
\alias{makeRMRanges,GRangesList,GRangesList-method}
\title{Form a set of random, matching ranges for bootstrapping or permuting}
\usage{
makeRMRanges(x, y, ...)

\S4method{makeRMRanges}{GRanges,GRanges}(
  x,
  y,
  exclude = GRanges(),
  n_iter = 1,
  n_total = NULL,
  replace = TRUE,
  ...,
  force_ol = TRUE
)

\S4method{makeRMRanges}{GRangesList,GRangesList}(
  x,
  y,
  exclude = GRanges(),
  n_iter = 1,
  n_total = NULL,
  replace = TRUE,
  mc.cores = 1,
  ...,
  force_ol = TRUE,
  unlist = TRUE
)
}
\arguments{
\item{x}{GRanges/GRangesList with ranges to be matched}

\item{y}{GRanges/GRangesList with ranges to select random matching ranges from}

\item{...}{Not used}

\item{exclude}{GRanges of ranges to omit from testing}

\item{n_iter}{The number of times to repeat the random selection process}

\item{n_total}{Setting this value will over-ride anything set using n_iter.
Can be vector of any length, corresponding to the length of x, when x is a
GRangesList}

\item{replace}{logical(1) Sample with our without replacement when creating
the set of random ranges.}

\item{force_ol}{logical(1) Enforce an overlap between every site in x and y}

\item{mc.cores}{Passsed to \link[parallel]{mclapply}}

\item{unlist}{logical(1) Return as a sorted GRanges object, or leave as a
GRangesList}
}
\value{
A GRanges or GRangesList object
}
\description{
Form a set of ranges from y which (near) exactly match those in x for use as
a background set requiring matching
}
\details{
This function uses the width distribution of the 'test' ranges (i.e. \code{x}) to
randomly sample a set of ranges with matching width from the ranges provided
in \code{y}. The width distribution will clearly be exact when a set of
fixed-width ranges is passed to \code{x}, whilst random sampling may yield some
variability when matching ranges of variable width.

When both x and y are GRanges objects, they are implicitly assumed to both
represent similar ranges, such as those overlapping a promoter or enhancer.
When passing two GRangesList objects, both objects are expected to contain
ranges annotated as belonging to key features, such that the list elements in
y must encompass all elements in x.
For example if \code{x} contains two elements named 'promoter' and 'intron', \code{y}
should also contain elements named 'promoter' and 'intron' and these will
be sampled as matching ranges for the same element in \code{x}. If elements of
\code{x} and \code{y} are not named, they are assumed to be in matching order.

The default behaviour is to assume that randomly-generated ranges are for
iteration, and as such, ranges are randomly formed in multiples of the number
of 'test' ranges provided in \code{x}. The column \code{iteration} will be added to the
returned ranges.
Placing any number into the \code{n_total} argument will instead select a total
number of ranges as specified here. In this case, no \code{iteration} column will
be included in the returned ranges.

Sampling is assumed to be with replacement as this is most suitable for
bootstrapping and related procedures, although this can be disabled by
setting \code{replace = FALSE}
}
\examples{
## Load the example peaks
data("ar_er_peaks")
sq <- seqinfo(ar_er_peaks)
## Now sample size-matched ranges for two iterations from chr1
makeRMRanges(ar_er_peaks, GRanges(sq)[1], n_iter = 2)

## Or simply sample 100 ranges if not planning any iterative analyses
makeRMRanges(ar_er_peaks, GRanges(sq)[1], n_total = 100)


}
