% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-Matched.R
\name{plotCovariate}
\alias{plotCovariate}
\alias{plotCovariate,Matched,character_OR_missing,character_OR_missing,character_OR_missing,character_OR_missing-method}
\title{Covariate plotting for Matched objects}
\usage{
plotCovariate(
  x,
  covar = NULL,
  sets = c("focal", "matched", "pool", "unmatched"),
  type = NULL,
  log = NULL,
  ...
)

\S4method{plotCovariate}{Matched,character_OR_missing,character_OR_missing,character_OR_missing,character_OR_missing}(x, covar, sets, type, log, thresh = 12)
}
\arguments{
\item{x}{Matched object}

\item{covar}{Character naming the covariate to plot.
If multiple are provided, only the first one is used.}

\item{sets}{Character vector describing which matched set(s)
to include in the plot. Options are 'focal', 'matched',
'pool', or 'unmatched'. Multiple options are accepted.}

\item{type}{Character naming the plot type. Available
options are one of either 'ridges', 'jitter', 'lines',
or 'bars'. Note that for large datasets, use of 'jitter'
is discouraged because the large density of points can
stall the R-graphics device.}

\item{log}{Character vector describing which axis or
axes to apply log-transformation. Available options are
'x' and/or 'y'.}

\item{...}{Additional arguments.}

\item{thresh}{Integer describing the number of
unique values required to classify a numeric
variable as discrete (and convert it to a factor).
If the number of unique values exceeds \code{thresh}
then the variable is considered continuous.}
}
\value{
Returns a plot of a covariate's distribution
among matched sets.
}
\description{
This function plots the distributions of a covariate
from each matched set of a Matched object.
}
\details{
By default, \code{plotCovariate} will sense the
class of covariate and make a plot best suited to
that data type. For example, if the covariate class
is categorical in nature then the \code{type} argument
defaults to 'bars'. \code{type} is set to 'lines' for
continuous covariates. These settings can also be overwritten
manually.
}
\examples{
## Matched example dataset
set.seed(123)
mdf <- makeExampleMatchedDataSet(matched = TRUE)

## Visualize covariates
plotCovariate(mdf)
plotCovariate(mdf, covar = 'feature3')
plotCovariate(mdf,
              covar = 'feature2',
              sets = c('focal', 'matched', 'pool'))
plotCovariate(mdf,
              covar = 'feature2',
              sets = c('focal', 'matched', 'pool'),
              type = 'ridges')
plotCovariate(mdf,
              covar = 'feature2',
              sets = c('focal', 'matched', 'pool'),
              type = 'jitter')

}
\seealso{
\code{\link[=plotPropensity]{plotPropensity()}} to plot propensity scores.
}
\concept{Matched plotting}
