% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{palette}
\alias{palette}
\alias{SampleColors}
\alias{ExtendPalette}
\alias{GetColorsForConditions}
\title{Palette for samples.}
\usage{
SampleColors(conds, pal.name = "Set1")

ExtendPalette(n, pal.name = "Set1")

GetColorsForConditions(conds, pal = NULL)
}
\arguments{
\item{conds}{A \code{character()} of conditions. The length of the vector is
the number of samples in the dataset.}

\item{pal.name}{A \code{character(1)} which is the name of the palette from the
package \link{RColorBrewer} from which the colors are taken. Default value
is 'Set1'.}

\item{n}{The number of desired colors in the palette}

\item{pal}{A vector of HEX color code that form the basis palette from which
to build the complete color vector for the conditions.}
}
\value{
A vector

A vector

A vector
}
\description{
Builds a vector of \verb{#conditions} colors for a set of samples. One color is
given for a given condition. This function extends a base palette from the
package \link{RColorBrewer} to 'n' colors.
The colors in the returned palette are always in the same order
}
\examples{

#-----------------------------------------------
# Builds a palette for a dataset with 3 conditions
# of 3 samples each.
#------------------------------------------------

conds <- c(rep("A", 3), rep("B", 3), rep("C", 3))
SampleColors(conds)
SampleColors(conds, "Dark2")


#-----------------------------------------------
# Extend the default palette to 12 colors
#-----------------------------------------------

ExtendPalette(12)


data(vdata)
conds <- get_group(vdata)
GetColorsForConditions(conds, ExtendPalette(2))

}
