% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pep_prot_CC.R
\name{pep_prot_CC}
\alias{pep_prot_CC}
\alias{buildGraph}
\alias{display.CC.visNet}
\alias{plotCCJitter}
\alias{GetCCInfos}
\title{Display a CC}
\usage{
buildGraph(cc = NULL, meta = NULL)

display.CC.visNet(g = NULL, layout = "layout_with_fr")

plotCCJitter(df, clickFunction = NULL)

GetCCInfos(cc)
}
\arguments{
\item{cc}{A list of connected component}

\item{meta}{A data.frame()}

\item{g}{An instance of a graph}

\item{layout}{A \code{character(1)} which i the layout used in visNetwork.
Default value is 'layout_with_fr'}

\item{df}{A data.frame()}

\item{clickFunction}{A JS function to determine the behaviour of a click}
}
\value{
A list

A plot

A plot

A \code{list} of three items:
\itemize{
\item \code{One_One}: the number of cc composed of one protein and one peptide
\item \code{One_Multi}: the number of cc composed of one protein and several peptides
\item \code{Multi_Multi}: the number of cc composed of several proteins and
several (shared) peptides.
}
}
\description{
Display a CC

Connected Components infos
}
\examples{
if (interactive()) {
    data(sub_R25)
    se <- sub_R25[[1]]
    g <- buildGraph(get_cc(se)[[1]])
    display.CC.visNet(g)
}

if (interactive()) {
    data(sub_R25)
    GetCCInfos(get_cc(sub_R25[[1]]))
}

}
\author{
Thomas Burger, Samuel Wieczorek
}
