% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_ILR.R
\name{shift}
\alias{shift}
\alias{shiftp}
\alias{shiftpInv}
\title{Shift data to origin given by p}
\usage{
shiftp(x, p)

shiftpInv(y, p)
}
\arguments{
\item{x}{closed compositional data matrix (or vector)}

\item{p}{weights (should not be closed)}

\item{y}{the shifted composition output by \code{shiftp}}
}
\value{
shifted data matrix \code{y} (no closure is applied) rows are
  samples, columns are parts
}
\description{
Shift must be applied before transformation
}
\examples{
p <- seq(.1,1,by=.2)
c <- t(rmultinom(10,100,c(.1,.6,.2,.3,.2))) + 0.65   # add a small pseudocount
x <- miniclo(c)
shiftp(x, p)
}
\references{
J. J. Egozcue, V. Pawlowsky-Glahn (2016) \emph{Changing the Reference
  Measure in the Simplex and its Weighting Effects}. Austrian Journal of
  Statistics 45(4):25-44
}
\author{
Justin Silverman & J. J. Egozcue
}
