% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassQualityReport.R
\docType{class}
\name{QualityReport-class}
\alias{QualityReport-class}
\title{QualityReport}
\description{
An S4 class storing quality related inputs and results in a SangerRead S4 object.
}
\section{Slots}{

\describe{
\item{\code{TrimmingMethod}}{The read trimming method for this SangerRead. The value must be \code{"M1"} (the default) or \code{'M2'}.}

\item{\code{M1TrimmingCutoff}}{The trimming cutoff for the Method 1. If \code{TrimmingMethod} is \code{"M1"}, then the default value is \code{0.0001}. Otherwise, the value must be \code{NULL}.}

\item{\code{M2CutoffQualityScore}}{The trimming cutoff quality score for the Method 2. If \code{TrimmingMethod} is \code{'M2'}, then the default value is \code{20}. Otherwise, the value must be \code{NULL}. It works with \code{M2SlidingWindowSize}.}

\item{\code{M2SlidingWindowSize}}{The trimming sliding window size for the Method 2. If \code{TrimmingMethod} is \code{'M2'}, then the default value is \code{10}. Otherwise, the value must be \code{NULL}. It works with \code{M2CutoffQualityScore}.}

\item{\code{qualityPhredScores}}{The Phred quality scores of each base pairs after base calling.}

\item{\code{qualityBaseScores}}{The probability of incorrect base call of each base pairs. They are calculated from \code{qualityPhredScores}.}

\item{\code{rawSeqLength}}{The number of nucleotides of raw primary DNA sequence.}

\item{\code{trimmedSeqLength}}{The number of nucleotides of trimeed  primary DNA sequence.}

\item{\code{trimmedStartPos}}{The base pair index of trimming start point from 5' end of the sequence.}

\item{\code{trimmedFinishPos}}{The base pair index of trimming finish point from 3' end of the sequence.}

\item{\code{rawMeanQualityScore}}{The mean quality score of the primary sequence after base calling. In other words, it is the mean of \code{qualityPhredScores}.}

\item{\code{trimmedMeanQualityScore}}{The mean quality score of the trimmed primary sequence after base calling.}

\item{\code{rawMinQualityScore}}{The minimum quality score of the primary sequence after base calling.}

\item{\code{trimmedMinQualityScore}}{The minimum quality score of the trimmed primary sequence after base calling.}

\item{\code{remainingRatio}}{The remaining sequence length ratio after trimming.}
}}

\examples{
inputFilesPath <- system.file("extdata/", package = "sangeranalyseR")
A_chloroticaFFN <- file.path(inputFilesPath,
                             "Allolobophora_chlorotica",
                             "ACHLO",
                             "Achl_ACHLO006-09_1_F.ab1")
sangerReadF <- new("SangerRead",
                    inputSource           = "ABIF",
                    readFeature           = "Forward Read",
                    readFileName          = A_chloroticaFFN,
                    geneticCode           = GENETIC_CODE,
                    TrimmingMethod        = "M1",
                    M1TrimmingCutoff      = 0.0001,
                    M2CutoffQualityScore  = NULL,
                    M2SlidingWindowSize   = NULL,
                    baseNumPerRow         = 100,
                    heightPerRow          = 200,
                    signalRatioCutoff     = 0.33,
                    showTrimmed           = TRUE)
"@"(sangerReadF, QualityReport)
}
\author{
Kuan-Hao Chao
}
